/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.google.gson.JsonParseException;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ControllerBlockEntity
extends ElevatorInputBlockEntity {
    private boolean initialized = false;
    private Direction facing;
    private String name;
    private DyeColor color = DyeColor.GRAY;
    private boolean showButtons = true;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super(MovingElevators.elevator_tile, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.initialized) {
            this.f_58857_.getCapability(ElevatorGroupCapability.CAPABILITY).ifPresent(cap -> cap.add(this));
            this.getGroup().updateFloorData(this, this.name, this.color);
            this.initialized = true;
        }
    }

    @Override
    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)ControllerBlock.FACING);
        }
        return this.facing;
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag compound = super.writeData();
        compound.m_128379_("hasName", this.name != null);
        if (this.name != null) {
            compound.m_128359_("name", this.name);
        }
        compound.m_128405_("color", this.color.m_41060_());
        compound.m_128379_("showButtons", this.showButtons);
        return compound;
    }

    @Override
    protected void readData(CompoundTag compound) {
        super.readData(compound);
        if (compound.m_128425_("hasName", 1)) {
            this.name = compound.m_128471_("hasName") ? compound.m_128461_("name") : null;
        } else if (compound.m_128441_("name")) {
            try {
                this.name = Component.Serializer.m_130701_((String)compound.m_128461_("name")).m_130668_(Integer.MAX_VALUE);
            }
            catch (JsonParseException ignore) {
                this.name = compound.m_128461_("name");
            }
        } else {
            this.name = null;
        }
        this.color = DyeColor.m_41053_((int)compound.m_128451_("color"));
        this.showButtons = !compound.m_128425_("showButtons", 1) || compound.m_128471_("showButtons");
    }

    public void onRemove() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ElevatorGroupCapability.CAPABILITY).ifPresent(groups -> groups.remove(this));
        }
    }

    @Override
    public String getFloorName() {
        return this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    public void setDisplayLabelColor(DyeColor color) {
        this.color = color;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        return this.color;
    }

    public boolean shouldShowButtons() {
        return this.showButtons;
    }

    public void toggleShowButtons() {
        this.showButtons = !this.showButtons;
        this.dataChanged();
    }

    @Override
    public ElevatorGroup getGroup() {
        return this.f_58857_.getCapability(ElevatorGroupCapability.CAPABILITY).map(groups -> groups.getGroup(this)).orElse(null);
    }

    @Override
    public boolean hasGroup() {
        return this.initialized && this.f_58857_.getCapability(ElevatorGroupCapability.CAPABILITY).map(groups -> groups.getGroup(this) != null).orElse(false) != false;
    }

    @Override
    public int getFloorLevel() {
        return this.f_58858_.m_123342_();
    }
}

